var canvas = document.getElementById("skeletonsCanvas");
var context = canvas.getContext("2d");
var eventmsg = document.getElementById("eventmsg");

function getSkeletons(jsonObject) {
	
  if (context == null) {
      return;
  }
  
  context.clearRect(0, 0, canvas.width, canvas.height);

  for (var i = 0; i < jsonObject.skeletons.length; i++) {
	var headZ = 0;
    var hipZ = 0;

    for (var j = 0; j < jsonObject.skeletons[i].joints.length; j++) 
    {
      var joint = jsonObject.skeletons[i].joints[j];
      
      // Draw!!!
      context.fillStyle = "#FF0000";
      context.beginPath();
      context.arc(joint.x, joint.y, 10, 0, Math.PI * 2, true);
      context.closePath();
      context.fill();
		
      // joint.name  values
      		//head
      		//hipleft
      
     }
	}
}

function setEventMsg(msg)
{
  eventmsg.innerHTML = "Event: " + msg ;
}
              
function msgFromArduino(value){
   setEventMsg('From Arduino: ' + value);   
  console.debug('From Arduino: ' + value);
}

function next() {
  setEventMsg("Next");   
  console.debug('Next');  
}

function prior() {
  setEventMsg("Prior");   
  console.debug('Prior');
}

function grip() {
  setEventMsg("Grip");   
  console.debug('Grip');  
  //$.get('http://192.168.1.97/open_B.act', function(responseText) {
    setEventMsg("Door Open... :)");
});
}

function release() {
  setEventMsg("Release");   
  console.debug('Release');
}

function noUser(){
  setEventMsg("No User");   
  console.debug('No User');  
//sendToArduino('0');
  
}

function newUser() {
  setEventMsg("New User");   
  console.debug('New User');  
  //sendToArduino('1');
}

function changeHandNone() {
  setEventMsg("Hand None");   
  console.debug('Hand None');  
}

function changeHandRight() {
  setEventMsg("Hand Right");   
  console.debug('Hand Right');  
}

function changeHandLeft() {
  setEventMsg("Hand Left");   
  console.debug('Hand Left');  
}


var recorder = function(){
    var containerId = "resultRecord";
  var debuggerId = "recordDebugger";
    var recording = false;
    var timeEnd = 0;
    var collection = [];
  var initialTime = 0;
    var toPlay = [];
  
	var startRecord = function(){
      collection = {};
       timeEnd = new Date().getTime()+initialTime;
       recorder.recording = true;
      setTimeout("recorder.stop()",initialTime);
    }
	var playRecord = function(){

      toPlay=[];
    	var justNow = new Date().getTime();
        var toExec = JSON.parse(document.getElementById(containerId).value);
        for (var key in toExec) {
			if(key<justNow){
              justNow=key;
            }
        }
        for (var key in toExec) {
          toPlay.push(toExec[key]);
           var refKey =  parseInt(key)-justNow;
           setTimeout(function(){
             console.log("exec");
            recorder.nextStep();
           }
             ,refKey);
        }
              
    }
    
    var nextStep = function(){
    	if(toPlay[0]!=undefined){
          getSkeletons(toPlay[0]);
          toPlay.shift();
        }
    }
    var stopRecord = function(){

      printDebugger("STOPED");
      recorder.recording=false;
      document.getElementById(containerId).innerHTML=JSON.stringify(collection);
      timeEnd=0;
      collection = {};
    }
    var saveStep = function(jsonRef){
      	var actualDate = new Date().getTime();
        if(timeEnd<actualDate){
          //Ya termina de grabar
          stopRecord();
        }else{
        	collection[actualDate]=jsonRef;  
        }
    	
    }
    
    var printDebugger = function(texto){
      try{
    	document.getElementById(debuggerId).innerHTML=texto;
      }
      catch(err){
      }
    }
    var timeOut = function(initTime){
      initialTime=initTime;
      printDebugger(3);
      setTimeout(function(){
      	printDebugger(2);
        setTimeout(function(){
          printDebugger(1);
          setTimeout(function(){
            recorder.startRecord();
            printDebugger("RECORDING");
          },1000);
        },1000);
      },1000);
    }
    return{
      startRecord: startRecord,
     start: timeOut,
      play: playRecord,
      stop:stopRecord,
      saveStep:saveStep,
      recording:recording,
      timeEnd:timeEnd,
      collection:collection,
      nextStep:nextStep
    }
}()
