/* application source */
var canvas = document.getElementById("skeletonsCanvas");
var context = canvas.getContext("2d");

function getSkeletons(jsonObject){
  
  
  
  if (context == null) {
      return;
  }
  try{
    if(recorder.recording){
      recorder.saveStep(jsonObject);
    }
  }catch(err){
  
  }
  
  context.clearRect(0, 0, canvas.width, canvas.height);

  for (var i = 0; i < jsonObject.skeletons.length; i++) {
	var headZ = 0;
    var hipZ = 0;

    //draw head
    var head = jsonObject.skeletons[i].joints[6];
    
    //http://www.codeproject.com/KB/dotnet/KinectGettingStarted/7.png
  //------------------------
  //[0] handright
  //[1] elbowright
  //[2] shoulderright
  //[3] handleft
  //[4] elbowleft
  //[5] shoulderleft
  //[6] head
  //[7] spineneck
  //[8] spinecenter
  //[9] hipcenter
  //[10] kneeleft
  //[11] kneeright
  //[12] ankleleft
  //[13] ankleright
    
    var shouldercenter = jsonObject.skeletons[i].joints[7];
    var shoulderleft = jsonObject.skeletons[i].joints[5];
    var shoulderright = jsonObject.skeletons[i].joints[2];
    var elbowright = jsonObject.skeletons[i].joints[1];
    var elbowleft = jsonObject.skeletons[i].joints[4];
    var handright = jsonObject.skeletons[i].joints[0];
    var handleft = jsonObject.skeletons[i].joints[3];
    //var wristright = jsonObject.skeletons[i].joints[10];
    //var wristleft = jsonObject.skeletons[i].joints[6];
    var hipcenter = jsonObject.skeletons[i].joints[9];
    var kneeleft = jsonObject.skeletons[i].joints[10];
    var kneeright = jsonObject.skeletons[i].joints[11];    
    var ankleleft = jsonObject.skeletons[i].joints[12];    
    var ankleright = jsonObject.skeletons[i].joints[13];    
    
    context.fillStyle = "#F7AF45"; //#EB5136
    context.strokeStyle = '#F7AF45'; 
    context.lineWidth = 10;
	
    
    context.beginPath()
    context.arc(head.x, head.y, 20, 0, Math.PI * 2, true);
    context.closePath()
    context.fill();	
    context.stroke(); 
    
    context.beginPath()
   		context.moveTo(head.x, head.y);
		context.lineTo(shouldercenter.x, shouldercenter.y);
    context.closePath()
    context.stroke(); 

    
    context.beginPath()
   		context.moveTo(shouldercenter.x, shouldercenter.y);
		context.lineTo(elbowright.x, elbowright.y);	    
    context.closePath()
    context.stroke(); 

   context.beginPath()
   		context.moveTo(elbowright.x, elbowright.y);
		context.lineTo(handright.x, handright.y);	    
    context.closePath()
    context.stroke(); 

    
   context.beginPath()
    	context.moveTo(shouldercenter.x, shouldercenter.y);
    	context.lineTo(elbowleft.x, elbowleft.y);
    context.closePath()
    context.stroke(); 

    context.beginPath()
   		context.moveTo(elbowleft.x, elbowleft.y);
		context.lineTo(handleft.x, handleft.y);	    
    context.closePath()
    context.stroke(); 
    
    context.beginPath()
    	context.moveTo(shouldercenter.x, shouldercenter.y);
    	context.lineTo(hipcenter.x, hipcenter.y);
    context.closePath()
    context.stroke(); 

    context.beginPath()
    	context.moveTo(hipcenter.x, hipcenter.y);
    	context.lineTo(kneeleft.x, kneeleft.y);    
    context.closePath()
    context.stroke(); 

    context.beginPath()
    	context.moveTo(kneeleft.x, kneeleft.y);
    	context.lineTo(ankleleft.x, ankleleft.y);    
    context.closePath()
    context.stroke(); 
    
    
    context.beginPath()
    	context.moveTo(hipcenter.x, hipcenter.y);
    	context.lineTo(kneeright.x, kneeright.y);    
     context.closePath()
    context.stroke(); 

    context.beginPath()
    	context.moveTo(kneeright.x, kneeright.y);
    	context.lineTo(ankleright.x, ankleright.y);    
    context.closePath()
    context.stroke(); 

    
    
    

    /*
    context.beginPath()
    context.arc(shoulderLeft.x, shoulderLeft.y, 20, 0, Math.PI * 2, true);
    context.closePath()
    context.fill();	
    context.stroke(); 
    
    context.beginPath()
    context.arc(shoulderRight.x, shoulderRight.y, 20, 0, Math.PI * 2, true);    
    context.closePath()
    context.fill();	
    context.stroke(); 

	*/
    
    
    
    
    /*for (var j = 0; j < jsonObject.skeletons[i].joints.length; j++) 
    {
      var joint = jsonObject.skeletons[i].joints[j];

      context.fillStyle = "#EC8B38";
      context.beginPath();
      context.arc(joint.x, joint.y, 10, 0, Math.PI * 2, true);
      context.closePath();
      context.fill();	
      
     }*/
	}
}


              
function msgFromArduino(value){
	console.debug('From Arduino: ' + value);
}

function next() {
	console.debug('Next!');  
}

function prior() {
	console.debug('Prior');
}

function noUser(){
  console.debug('No User :(');  
//sendToArduino('0');
  
}

function newUser() {
  console.debug('New User :)');  
  //sendToArduino('1');
}

function changeHandNone() {
	console.debug('Hand None');  
}

function changeHandRight() {
  	console.debug('Hand Right');  
}

function changeHandLeft() {
	console.debug('Hand Left');  
}

var recorder = function(){
    var containerId = "resultRecord";
  var debuggerId = "recordDebugger";
    var recording = false;
    var timeEnd = 0;
    var collection = [];
  var initialTime = 0;
    var toPlay = [];
  
	var startRecord = function(){
      collection = {};
       timeEnd = new Date().getTime()+initialTime;
       recorder.recording = true;
      setTimeout("recorder.stop()",initialTime);
    }
	var playRecord = function(){

      toPlay=[];
    	var justNow = new Date().getTime();
        var toExec = JSON.parse(document.getElementById(containerId).value);
        for (var key in toExec) {
			if(key<justNow){
              justNow=key;
            }
        }
        for (var key in toExec) {
          toPlay.push(toExec[key]);
           var refKey =  parseInt(key)-justNow;
           setTimeout(function(){
             console.log("exec");
            recorder.nextStep();
           }
             ,refKey);
        }
              
    }
    
    var nextStep = function(){
    	if(toPlay[0]!=undefined){
          getSkeletons(toPlay[0]);
          toPlay.shift();
        }
    }
    var stopRecord = function(){

      printDebugger("STOPED");
      recorder.recording=false;
      document.getElementById(containerId).innerHTML=JSON.stringify(collection);
      timeEnd=0;
      collection = {};
    }
    var saveStep = function(jsonRef){
      	var actualDate = new Date().getTime();
        if(timeEnd<actualDate){
          //Ya termina de grabar
          stopRecord();
        }else{
        	collection[actualDate]=jsonRef;  
        }
    	
    }
    
    var printDebugger = function(texto){
      try{
    	document.getElementById(debuggerId).innerHTML=texto;
      }
      catch(err){
      }
    }
    var timeOut = function(initTime){
      initialTime=initTime;
      printDebugger(3);
      setTimeout(function(){
      	printDebugger(2);
        setTimeout(function(){
          printDebugger(1);
          setTimeout(function(){
            recorder.startRecord();
            printDebugger("RECORDING");
          },1000);
        },1000);
      },1000);
    }
    return{
      startRecord: startRecord,
     start: timeOut,
      play: playRecord,
      stop:stopRecord,
      saveStep:saveStep,
      recording:recording,
      timeEnd:timeEnd,
      collection:collection,
      nextStep:nextStep
    }
}()
